<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');
include '../config.php';

if (!isset($pdo)) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection not initialized']);
    exit;
}

// Lấy dữ liệu JSON từ POST hoặc fallback từ GET
$input = json_decode(file_get_contents('php://input'), true);
if (!$input || !isset($input['action'])) {
    $input = $_GET;
}

$action = $input['action'] ?? null;
$clientId = $input['client_id'] ?? null;
$toolType = $input['tool_type'] ?? null;

if (!$action || !$clientId || !$toolType) {
    echo json_encode(['status' => 'error', 'message' => 'Missing parameters']);
    exit;
}

switch ($action) {
    case 'start_trial':
        // Kiểm tra xem client đã có trial chưa
        $stmt = $pdo->prepare("SELECT trial_start, has_used FROM trials WHERE client_id = :cid AND tool_type = :tt");
        $stmt->execute([':cid' => $clientId, ':tt' => $toolType]);
        $existing = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($existing) {
            // Nếu đã có trial, trả lại thông tin hiện tại
            $trialStart = new DateTime($existing['trial_start'], new DateTimeZone('UTC'));
            echo json_encode([
                'status' => 'used',
                'trial_start' => $trialStart->format(DATE_ATOM), // ISO 8601
                'has_used' => (bool)$existing['has_used']
            ]);
            exit;
        }

        // Nếu chưa có, tạo trial mới
        $now = new DateTime('now', new DateTimeZone('UTC'));
        $stmt = $pdo->prepare("INSERT INTO trials (client_id, tool_type, trial_start, has_used) VALUES (:cid, :tt, :start, 0)");
        $stmt->execute([
            ':cid' => $clientId,
            ':tt' => $toolType,
            ':start' => $now->format('Y-m-d H:i:s') // Lưu vào DB định dạng này là đủ
        ]);

        echo json_encode([
            'status' => 'ok',
            'trial_start' => $now->format(DATE_ATOM) // Trả ra định dạng ISO 8601 cho C#
        ]);
        exit;

    case 'check_trial':
        $stmt = $pdo->prepare("SELECT trial_start, has_used FROM trials WHERE client_id = :cid AND tool_type = :tt");
        $stmt->execute([':cid' => $clientId, ':tt' => $toolType]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$row) {
            echo json_encode(['status' => 'not_found']);
            exit;
        }

        $trialStart = new DateTime($row['trial_start'], new DateTimeZone('UTC'));
        echo json_encode([
            'status' => 'ok',
            'trial_start' => $trialStart->format(DATE_ATOM),
            'has_used' => (bool)$row['has_used']
        ]);
        exit;

    case 'mark_trial_used':
        $stmt = $pdo->prepare("UPDATE trials SET has_used = 1 WHERE client_id = :cid AND tool_type = :tt");
        $stmt->execute([':cid' => $clientId, ':tt' => $toolType]);
        echo json_encode(['status' => 'ok']);
        exit;

    default:
        echo json_encode(['status' => 'error', 'message' => 'Unknown action']);
        exit;
}
