<?php
header('Content-Type: application/json');

// Đọc JSON từ body
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// Validate input
if (!is_array($data) 
    || empty($data['key']) 
    || empty($data['tool_type']) 
    || empty($data['client_id'])) 
{
    http_response_code(400);
    exit(json_encode([
        "status"  => "fail",
        "message" => "Thiếu key/tool_type/client_id."
    ]));
}

$key      = $data['key'];
$toolType = $data['tool_type'];
$clientId = $data['client_id'];

// Kết nối DB từ config.php (phải khởi tạo $mysqli)
include '../config.php';
if (!$mysqli || $mysqli->connect_error) {
    http_response_code(500);
    exit(json_encode([
        "status"  => "error",
        "message" => "Kết nối database thất bại."
    ]));
}

// Lấy record key
$stmt = $mysqli->prepare("SELECT * FROM license_keys WHERE key_value = ?");
$stmt->bind_param("s", $key);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();

if (!$row) {
    http_response_code(404);
    $resp = ["status"=>"fail","message"=>"Key không tồn tại."];
}
else {
    // Kiểm tra tool_type
    if ($row['tool_type'] !== $toolType) {
        http_response_code(400);
        $resp = ["status"=>"fail","message"=>"Sai loại tool."];
    }
    // Kiểm tra banned
    elseif ($row['status'] === 'banned') {
        http_response_code(403);
        $resp = ["status"=>"fail","message"=>"Key đã bị khóa."];
    }
    else {
        $today = date("Y-m-d");
        if ($today < $row['start_date'] || $today > $row['end_date']) {
            http_response_code(400);
            $resp = ["status"=>"fail","message"=>"Key hết hạn hoặc chưa kích hoạt."];
        }
        else {
            // Kiểm tra binding client
            if (empty($row['client_id'])) {
                // Lần đầu kích hoạt: bind client_id
                $u = $mysqli->prepare(
                  "UPDATE license_keys 
                   SET client_id = ?, activated_at = NOW() 
                   WHERE id = ?"
                );
                $u->bind_param("si", $clientId, $row['id']);
                $u->execute();
                $u->close();

                $resp = [
					"status"  => "success",
					"message" => "Key đã được kích hoạt cho thiết bị này.",
					"band"    => $row['band']
				];
            }
            elseif ($row['client_id'] === $clientId) {
                // Đúng client
                $resp = [
					"status"  => "success",
					"message" => "Key hợp lệ cho thiết bị này.",
					"band"    => $row['band'] // thêm dòng này
				];
            }
            else {
                // Client khác
                http_response_code(403);
                $resp = ["status"=>"fail","message"=>"Key đã được sử dụng trên thiết bị khác."];
            }
        }
    }
}

$stmt->close();
$mysqli->close();
echo json_encode($resp);
