<?php
header('Content-Type: application/json');

include '../config/config.php';

// Lấy dữ liệu từ yêu cầu
$data = json_decode(file_get_contents('php://input'), true);
$mac_address = $data['mac_address'] ?? null;
$reason = $data['reason'] ?? 'No reason specified';

if (empty($mac_address)) {
    die(json_encode(["status" => "error", "message" => "MAC address is required."]));
}

// Thực hiện chuẩn bị câu lệnh
$stmt = $conn->prepare("INSERT INTO banned_macs (mac_address, reason) VALUES (?, ?)");
if (!$stmt) {
    die(json_encode(["status" => "error", "message" => "Error preparing statement: " . $conn->error]));
}

// Liên kết tham số
$stmt->bind_param("ss", $mac_address, $reason);

// Thực thi câu lệnh
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "MAC address banned successfully."]);
} else {
    echo json_encode(["status" => "error", "message" => "Error banning MAC address: " . $stmt->error]);
}

// Đóng kết nối
$stmt->close();
$conn->close();
?>
