<?php
header('Content-Type: application/json');

include '../config/config.php';

// Lấy địa chỉ MAC từ yêu cầu
$mac_address = $_GET['mac_address'];

if (empty($mac_address)) {
    die(json_encode(["status" => "error", "message" => "MAC address is required."]));
}

// Thực hiện chuẩn bị câu lệnh
$stmt = $conn->prepare("SELECT * FROM baned_ip WHERE mac_address = ?");
if (!$stmt) {
    die(json_encode(["status" => "error", "message" => "Error preparing statement: " . $conn->error]));
}

// Liên kết tham số
$stmt->bind_param("s", $mac_address);

// Thực thi câu lệnh
$stmt->execute();

// Lấy kết quả
$result = $stmt->get_result();

$response = ["status" => "success", "is_banned" => false];

if ($result->num_rows > 0) {
    $response["is_banned"] = true;
}

echo json_encode($response);

// Đóng kết nối
$stmt->close();
$conn->close();
?>
