<?php
include '../config/config.php';

// Lấy tiêu chí lọc từ yêu cầu GET (có thể là user_id, ip_address, mac_address, v.v.)
$user_id = $_GET['user_id'] ?? '';
$ip_address = $_GET['ip_address'] ?? '';
$mac_address = $_GET['mac_address'] ?? '';

$query = "SELECT user_id, is_active, ip_address, mac_address, timestamp FROM user_activity WHERE 1=1";

if (!empty($user_id)) {
    $query .= " AND user_id = ?";
}

if (!empty($ip_address)) {
    $query .= " AND ip_address = ?";
}

if (!empty($mac_address)) {
    $query .= " AND mac_address = ?";
}

$query .= " ORDER BY timestamp DESC";

$stmt = $conn->prepare($query);

if (!empty($user_id) && !empty($ip_address) && !empty($mac_address)) {
    $stmt->bind_param("sss", $user_id, $ip_address, $mac_address);
} elseif (!empty($user_id) && !empty($ip_address)) {
    $stmt->bind_param("ss", $user_id, $ip_address);
} elseif (!empty($user_id)) {
    $stmt->bind_param("s", $user_id);
}

$stmt->execute();
$result = $stmt->get_result();

$userActivities = [];

while ($row = $result->fetch_assoc()) {
    $userActivities[] = $row;
}

echo json_encode($userActivities);

$stmt->close();
$conn->close();
?>
