<?php
include '../config/config.php';

// Lấy giá trị mã máy từ POST
$machineCode = $_POST['machineCode'] ?? '';  

if (!empty($machineCode)) {
    // Kiểm tra nếu `MachineCode` đã tồn tại trong cơ sở dữ liệu
    $sql = "SELECT * FROM TrialMachines WHERE MachineCode = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        echo "Lỗi khi chuẩn bị câu lệnh SQL: " . $conn->error;
        exit;
    }

    $stmt->bind_param("s", $machineCode);

    if ($stmt->execute()) {
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            // Nếu máy đã tồn tại, lấy `StartDate` từ cơ sở dữ liệu
            $row = $result->fetch_assoc();
            $startDate = $row['StartDate'];  // Ngày bắt đầu trial
            $currentDate = new DateTime();  // Ngày hiện tại
            $expiryDate = new DateTime($startDate);  // Ngày bắt đầu trial

            // Kiểm tra xem trial có hết hạn không
            if ($currentDate > $expiryDate) {
                echo "Trial đã hết hạn vui lòng mua key.";
            } else {
                // Nếu còn hiệu lực, trả về ngày hết hạn
                echo "Trial còn hiệu lực. Hạn sử dụng đến: " . $expiryDate->format('Y-m-d H:i:s');
            }
        } else {
            // Nếu máy chưa tồn tại, lưu vào cơ sở dữ liệu và cộng thêm 1 ngày vào StartDate
            $stmt_insert = $conn->prepare("INSERT INTO TrialMachines (MachineCode, StartDate) VALUES (?, NOW())");
            
            if ($stmt_insert === false) {
                echo "Lỗi khi chuẩn bị câu lệnh SQL cho insert: " . $conn->error;
                exit;
            }

            $stmt_insert->bind_param("s", $machineCode);
            
            if ($stmt_insert->execute()) {
                // Cập nhật StartDate để cộng thêm 1 ngày
                $stmt_update = $conn->prepare("UPDATE TrialMachines SET StartDate = DATE_ADD(StartDate, INTERVAL 1 DAY) WHERE MachineCode = ?");
                
                if ($stmt_update === false) {
                    echo "Lỗi khi chuẩn bị câu lệnh SQL cho update: " . $conn->error;
                    exit;
                }

                $stmt_update->bind_param("s", $machineCode);
                $stmt_update->execute();

                echo "Trial đã được kích hoạt và thời gian trial được gia hạn thêm 1 ngày.";
            } else {
                echo "Lỗi khi lưu mã máy.";
            }
        }
    } else {
        echo "Lỗi khi truy vấn cơ sở dữ liệu: " . $stmt->error;
    }

    // Đóng kết nối
    $stmt->close();
    if (isset($stmt_insert)) $stmt_insert->close();  // Kiểm tra xem $stmt_insert đã được khởi tạo chưa trước khi đóng
    if (isset($stmt_update)) $stmt_update->close();  // Kiểm tra tương tự với $stmt_update
} else {
    echo "Vui lòng cung cấp mã máy.";
}

// Đóng kết nối cơ sở dữ liệu
$conn->close();
?>
