<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id']) && isset($_POST['action'])) {
    $id = $_POST['id'];
    $action = $_POST['action'];

    include '../config/config.php';

    if ($action == 'approve') {
        $stmt = $conn->prepare("UPDATE uploads SET status = 'approved' WHERE id = ?");
    } else if ($action == 'reject') {
        $stmt = $conn->prepare("UPDATE uploads SET status = 'rejected' WHERE id = ?");
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Invalid action.'));
        $conn->close();
        exit();
    }

    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        echo json_encode(array('status' => 'success', 'message' => 'Action completed.'));
    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Failed to update status.'));
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid request.'));
}
?>
