<?php
$target_dir = "uploads/";
$uploadOk = 1;
$maxFileSize = 50 * 1024 * 1024; // 100MB
$response = array();

// Kiểm tra xem có tệp nào được tải lên không
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['file']) && isset($_POST['title']) && isset($_POST['description'])) {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $target_file = $target_dir . basename($_FILES["file"]["name"]);
    $fileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $fileSize = $_FILES["file"]["size"];

    // Kiểm tra định dạng tệp
    $allowedTypes = array("mp3", "wav", "ogg");
    if (!in_array($fileType, $allowedTypes)) {
        $response['status'] = "error";
        $response['message'] = "Only MP3, WAV, and OGG files are allowed.";
        $uploadOk = 0;
    }

    // Kiểm tra kích thước tệp
    if ($fileSize > $maxFileSize) {
        $response['status'] = "error";
        $response['message'] = "File is too large. Maximum allowed size is 50MB.";
        $uploadOk = 0;
    }

    // Kiểm tra nếu file không hợp lệ
    if ($uploadOk == 0) {
        $response['status'] = "error";
        $response['message'] = "File is not valid.";
    } else {
        // Kiểm tra và tạo thư mục nếu cần thiết
        if (!file_exists($target_dir)) {
            if (!mkdir($target_dir, 0777, true)) {
                $response['status'] = "error";
                $response['message'] = "Failed to create upload directory.";
                echo json_encode($response);
                exit();
            }
        }

        // Kiểm tra nếu tệp đã tồn tại
        if (file_exists($target_file)) {
            $response['status'] = "error";
            $response['message'] = "File already exists.";
        } else {
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
                // Kết nối cơ sở dữ liệu
                $conn = new mysqli("localhost", "root", "", "test");

                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }

                // Thêm thông tin vào cơ sở dữ liệu
                $stmt = $conn->prepare("INSERT INTO upload_music (title, description, filename, status) VALUES (?, ?, ?, 'pending')");
                $stmt->bind_param("sss", $title, $description, $target_file);
                if ($stmt->execute()) {
                    $response['status'] = "success";
                    $response['message'] = "File has been uploaded and is pending approval.";
                } else {
                    $response['status'] = "error";
                    $response['message'] = "Failed to save file info to database.";
                }

                $stmt->close();
                $conn->close();
            } else {
                $response['status'] = "error";
                $response['message'] = "There was an error uploading your file.";
            }
        }
    }
} else {
    $response['status'] = "error";
    $response['message'] = "No file or required information provided.";
}

echo json_encode($response);
?>
